/*
 * file name: Robojax_HeltecLoRa32.h
 * version 1.1.0
 * written on July 03, 2025 by Ahamd Shamshiri www.Robojax.com
 * Description:
 * This file contains the definition of the Robojax_HeltecLoRa32 class,
 * which provides methods for interacting with the Heltec LoRa32 board.
 */
#ifndef Robojax_HeltecLoRa32_h
#define Robojax_HeltecLoRa32_h

#include <Arduino.h>
#include "mbedtls/aes.h"

class SSD1306Wire;

class Robojax_HeltecLoRa32 {
public:
    Robojax_HeltecLoRa32();
    Robojax_HeltecLoRa32(SSD1306Wire* externalDisplay);

    void begin();
    void setDisplay(SSD1306Wire* disp);
    void displayText(String text, int x, int y, int fontSize, int align, bool clear = false);
    void displayCenteredText(String text, int y, int fontSize = 16);
    void displayLineText(String text, int x, int y, int fontSize, bool clear);
    void displayClearLine(int y, int fontSize);
    void clear();
    void displaySmallBattery(float voltage);
    void displayLargeBattery(float voltage, int type);
    float interBatteryVoltage; // Global-like public variable
    float readInternalBattery(); // Call to read and update voltage
    void sendBatteryVoltage();
    float readAnyVoltage(int adcPin, float R1, float R2);
    void sendString(String str);
    void maxVoltage(int R1, int R2);
    void calculatResistor(int R2, float voltage);
    void clearLineArea(int x, int y, int fontSize);
    void sendStringSecure(String str);
    void encryptAES(uint8_t *data, const char *key);
    void decryptAES(uint8_t *data, const char *key);
    




private:
    SSD1306Wire* display = nullptr;
    void setFontSize(int fontSize);
    void processKey(const char *userKey, uint8_t *processedKey, size_t keySize);

};

#endif
