/*
file name: Relay_Secure_RX
Written on May 13, 2025
This sketch will receive and decrypte the  ON or OFF signal from LoRa RF 
and turns the RELAY_CONTROL_PIN on or off.
The relay is connected to the GPIO4 pin. Or you my connect a buzzer to this pin.

Watch Full video instruction: https://youtu.be/lhLQqG5H8_M

This code has been part of Robojax_HeltecLoRa32 library which can be downloaded from robojax.com

*/

#include <Wire.h>
#include <HT_SSD1306Wire.h>
#include "LoRaWan_APP.h"
#include <Robojax_HeltecLoRa32.h>

bool debug = false;


#define RELAY_CONTROL_PIN 4 // alaram pin

#define BATTERY_PIN 1  //do not change (internal battery)
#define ADC_CTRL_PIN 37  //do not change (internally used pin)

const char *displayTextTitle = "Relay:"; //shown on the screen
const char *displayTextTX = "(RX)"; //shown on the screen
const char *displayTextRelayON = "ON"; //shown on the screen
const char *displayTextRelayOFF = "OFF"; //shown on the screen

const char *displayTextRelayToggleON = "TOG-ON"; //shown on the screen
const char *displayTextRelayToggleOFF = "TOG-OFF"; //shown on the screen
const int transmitDelayTime = 1000;
const char* displayTexRelayText[] = {displayTextRelayON, displayTextRelayOFF, displayTextRelayToggleON, displayTextRelayToggleOFF};



mbedtls_aes_context aes;
const char *userKey = "6tfDs$wEq3!"; //Security key. 
#define RF_FREQUENCY 915555000 // Hz. Must match the frequency of the transmitter

SSD1306Wire oledDisplay(0x3c, 500000, SDA_OLED, SCL_OLED, GEOMETRY_128_64, RST_OLED);
Robojax_HeltecLoRa32 robojaxDisplay(&oledDisplay);

bool relayState;
String displayTextStateValue; 



#define TX_OUTPUT_POWER                             2        // dBm from 2 to 20. when powered via battery 2 to 14dBm

#define LORA_BANDWIDTH                              0         // [0: 125 kHz,
                                                              //  1: 250 kHz,
                                                              //  2: 500 kHz,
                                                              //  3: Reserved]
#define LORA_SPREADING_FACTOR                       7         // [SF7..SF12]
#define LORA_CODINGRATE                             1         // [1: 4/5,
                                                              //  2: 4/6,
                                                              //  3: 4/7,
                                                              //  4: 4/8]
#define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                         0         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_IQ_INVERSION_ON                        false


#define RX_TIMEOUT_VALUE                            1000
#define BUFFER_SIZE                                 30 // Define the payload size here

char txpacket[BUFFER_SIZE];
char rxpacket[BUFFER_SIZE];
bool lora_idle=true;
static RadioEvents_t RadioEvents;

void VextON() {
    pinMode(Vext, OUTPUT);
    digitalWrite(Vext, LOW);
}

void OnTxDone(void);
void OnTxTimeout(void);




void setup() {
  Serial.begin(115200);
  Serial.println();
  Serial.println();
  pinMode(RELAY_CONTROL_PIN, OUTPUT);//set this pin as output for the relay
  VextON();
  delay(100);
  robojaxDisplay.begin(); 

  //LoRa stuff blow this line
     Mcu.begin(HELTEC_BOARD,SLOW_CLK_TPYE);
    
  
    RadioEvents.RxDone = OnRxDone;
    Radio.Init( &RadioEvents );
    Radio.SetChannel( RF_FREQUENCY );
    Radio.SetRxConfig( MODEM_LORA, LORA_BANDWIDTH, LORA_SPREADING_FACTOR,
                               LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                               LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON,
                               0, true, 0, 0, LORA_IQ_INVERSION_ON, true );
}




void loop() {
  if(debug)
  {
  Serial.print(displayTextTitle);Serial.print(" ");
  Serial.println(displayTextStateValue);
  }

 
    robojaxDisplay.displayLineText(displayTextTitle, 0, 0, 24, false);//size 24 font
    robojaxDisplay.displayText(displayTextTX, 127, 5, 10, TEXT_ALIGN_RIGHT);//display TX on the right side

    robojaxDisplay.displayLineText(displayTextStateValue, 0, 30, 24, true);//size 24 font

  if(relayState == true)
  {
    relayON();
  }else{
    relayOFF();
  }

  Radio.IrqProcess( );
  if(lora_idle)
  {
    lora_idle = false;
    Serial.println("into RX mode");
    Radio.Rx(0);
  }

  delay(100);

}

bool isInList(const String& text) {
  for(int i = 0; i < 4; i++) {
    if(text.equals(displayTexRelayText[i])) return true;
  }
  return false;
}

void relayON()
{
  
  digitalWrite(RELAY_CONTROL_PIN, HIGH);
  delay(transmitDelayTime);
}

void relayOFF()
{
  digitalWrite(RELAY_CONTROL_PIN, LOW);
}
void OnRxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{

    if (size >= BUFFER_SIZE) size = BUFFER_SIZE - 1;
    memcpy(rxpacket, payload, size);
    rxpacket[size] = '\0'; // null-terminate safely

    Radio.Sleep();

    if (debug) {
        Serial.printf("\nReceived packet: \"%s\" | RSSI: %d | Length: %d\n", rxpacket, rssi, size);
    }

    robojaxDisplay.decryptAES((uint8_t *)rxpacket, userKey);

    displayTextStateValue = String((char*)rxpacket);
    relayState = (strcmp(displayTextStateValue.c_str(), displayTextRelayON) == 0) || (strcmp(displayTextStateValue.c_str(), displayTextRelayToggleON) == 0);

    if(isInList(displayTextStateValue)) {

      if (debug)
      Serial.println("Exact match found");
    }else{
      displayTextStateValue ="--";
    }
    if (debug) {
        Serial.print("Decrypted: ");
        Serial.print(displayTextStateValue);
        Serial.print(" relayState:");
        Serial.println(relayState);
    }


    lora_idle = true;
}
