/*
Written on April 12, 2025
written  for www.NyBot.cc
this sktech receives the secure voltage from WiFi LoRa 32 and decrypts it
and displays it on the OLED. There is action feature to triggerd if the temperature is below triggerdValue
Watch full video explaination https://youtu.be/rOVVl9EI-So
*/
/*
TEXT_ALIGN_LEFT 0
TEXT_ALIGN_CENTER 1
TEXT_ALIGN_RIGHT 2
*/
#include <Wire.h>
#include <HT_SSD1306Wire.h>
#include "LoRaWan_APP.h"
#include <Robojax_HeltecLoRa32.h>

bool debug = false;

float voltage;

const float CALIB_FACTOR = 1.075f;   // Your calibration factor. 1.0 means do not callibrate
#define BATTERY_PIN 1  //do not change
#define ADC_CTRL_PIN 37  //do not change

const char *displayTexttitle = "Voltage:"; //shown on the screen
const char *displayTexRX = "(RX)"; //shown on the screen

mbedtls_aes_context aes;
const char *userKey = "hyhT676#h~_876s"; //Security key. 

SSD1306Wire oledDisplay(0x3c, 500000, SDA_OLED, SCL_OLED, GEOMETRY_128_64, RST_OLED);
Robojax_HeltecLoRa32 robojaxDisplay(&oledDisplay);


#define RF_FREQUENCY                                915000000 // Hz

#define TX_OUTPUT_POWER                             2        // dBm from 2 to 20. when powered via battery 2 to 14dBm

#define LORA_BANDWIDTH                              0         // [0: 125 kHz,
                                                              //  1: 250 kHz,
                                                              //  2: 500 kHz,
                                                              //  3: Reserved]
#define LORA_SPREADING_FACTOR                       7         // [SF7..SF12]
#define LORA_CODINGRATE                             1         // [1: 4/5,
                                                              //  2: 4/6,
                                                              //  3: 4/7,
                                                              //  4: 4/8]
#define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                         0         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_IQ_INVERSION_ON                        false


#define RX_TIMEOUT_VALUE                            1000
#define BUFFER_SIZE                                 30 // Define the payload size here

char txpacket[BUFFER_SIZE];
char rxpacket[BUFFER_SIZE];
bool lora_idle=true;
static RadioEvents_t RadioEvents;

void VextON() {
    pinMode(Vext, OUTPUT);
    digitalWrite(Vext, LOW);
}

void OnTxDone(void);
void OnTxTimeout(void);

void decryptAES(uint8_t *data, const char *key);
void encryptAES(uint8_t *data, const char *key);
void processKey(const char *userKey, uint8_t *processedKey, size_t keySize);



void setup() {
  Serial.begin(115200);
  Serial.println();
  Serial.println();
  VextON();
  delay(100);
  robojaxDisplay.begin(); 

  //LoRa stuff blow this line
     Mcu.begin(HELTEC_BOARD,SLOW_CLK_TPYE);
    
  
    RadioEvents.RxDone = OnRxDone;
    Radio.Init( &RadioEvents );
    Radio.SetChannel( RF_FREQUENCY );
    Radio.SetRxConfig( MODEM_LORA, LORA_BANDWIDTH, LORA_SPREADING_FACTOR,
                               LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                               LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON,
                               0, true, 0, 0, LORA_IQ_INVERSION_ON, true );
}




void loop() {

    String stringVoltage = String(voltage);  
    robojaxDisplay.displayLineText("Voltage:", 0, 0, 24, false);//size 24 font
    robojaxDisplay.displayText(displayTexRX, 127, 5, 10, TEXT_ALIGN_RIGHT);//display TX on the right side

    robojaxDisplay.displayLineText(stringVoltage+"V", 0, 30, 24, true);//size 24 font

  if(voltage > 24.6)
  {
    //aCTION
  }

  Radio.IrqProcess( );
  if(lora_idle)
  {
    lora_idle = false;
    Serial.println("into RX mode");
    Radio.Rx(0);
  }

  delay(100);

}

void OnRxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{

    if (size >= BUFFER_SIZE) size = BUFFER_SIZE - 1;
    memcpy(rxpacket, payload, size);
    rxpacket[size] = '\0'; // null-terminate safely

    Radio.Sleep();

    if (debug) {
        Serial.printf("\nReceived packet: \"%s\" | RSSI: %d | Length: %d\n", rxpacket, rssi, size);
    }

    decryptAES((uint8_t *)rxpacket, userKey);

    String receivedStr = String((char*)rxpacket);

    if (debug) {
        Serial.print("Decrypted: ");
        Serial.println(receivedStr);
    }

    float floatValue = receivedStr.toFloat();
    voltage = floatValue;

    if (debug) {
        Serial.print("Parsed floatValue: ");
        Serial.println(floatValue);
    }

    lora_idle = true;
}
/**
 * Converts a user-provided plaintext key into a fixed-length 16-byte (128-bit)
 * or 32-byte (256-bit) key.
 */
void processKey(const char *userKey, uint8_t *processedKey, size_t keySize) {
    memset(processedKey, 0, keySize); // Fill with zeros
    size_t len = strlen(userKey);
    if (len > keySize) len = keySize; // Truncate if too long
    memcpy(processedKey, userKey, len); // Copy valid key part
}

/**
 * Encrypts a 16-byte (one block) message using AES-128.
 */
void encryptAES(uint8_t *data, const char *key) {
    uint8_t processedKey[16]; // 128-bit key
    processKey(key, processedKey, 16);

    mbedtls_aes_init(&aes);
    mbedtls_aes_setkey_enc(&aes, processedKey, 128);
    mbedtls_aes_crypt_ecb(&aes, MBEDTLS_AES_ENCRYPT, data, data);
    mbedtls_aes_free(&aes);
}

/**
 * Decrypts a 16-byte (one block) message using AES-128.
 */
void decryptAES(uint8_t *data, const char *key) {
    uint8_t processedKey[16]; // 128-bit key
    processKey(key, processedKey, 16);

    mbedtls_aes_init(&aes);
    mbedtls_aes_setkey_dec(&aes, processedKey, 128);
    mbedtls_aes_crypt_ecb(&aes, MBEDTLS_AES_DECRYPT, data, data);
    mbedtls_aes_free(&aes);
}