/*
TEXT_ALIGN_LEFT 0
TEXT_ALIGN_CENTER 1
TEXT_ALIGN_RIGHT 2
*/
#include <Wire.h>
#include <HT_SSD1306Wire.h>
#include <Robojax_HeltecLoRa32.h>

SSD1306Wire oledDisplay(0x3c, 500000, SDA_OLED, SCL_OLED, GEOMETRY_128_64, RST_OLED);
Robojax_HeltecLoRa32 robojaxDisplay(&oledDisplay);

void VextON() {
    pinMode(Vext, OUTPUT);
    digitalWrite(Vext, LOW);
}

void setup() {
    Serial.begin(115200);
    VextON();
    delay(100); // OLED power on delay

    robojaxDisplay.begin(); 

    robojaxDisplay.displayText("Hello", 0, 0, 16, TEXT_ALIGN_LEFT);
    delay(1000);



}

void loop() {

    robojaxDisplay.displayCenteredText("Robojax!", 24, 24); // Y=24, font size 24
    delay(2000);
    robojaxDisplay.displayText("Temp: 23.5°C", 0, 24, 16, TEXT_ALIGN_CENTER);
    delay(2000);
    robojaxDisplay.displayLineText("Line 1", 0, 30, 10);
    robojaxDisplay.displayLineText("Line 2", 0, 40, 10); // Draws on line 2 without clearing line 1
    delay(2000);

    
    

}


