/*
file name: Relay_Secure_RX
Written on May 13, 2025
This sketch will receive and decrypte the  ON or OFF signal from LoRa RF 
and turns the RELAY_CONTROL_PIN on or off.
The relay is connected to the GPIO4 pin. Or you my connect a buzzer to this pin.

Watch Full video instruction: https://youtu.be/lhLQqG5H8_M

This code has been part of Robojax_HeltecLoRa32 library can be downloaded from robojax.com

*/

#include <Wire.h>
#include <HT_SSD1306Wire.h>
#include "LoRaWan_APP.h"
#include <Robojax_HeltecLoRa32.h>

bool debug = false;


#define RELAY_CONTROL_PIN 4 // alaram pin

#define BATTERY_PIN 1  //do not change (internal battery)
#define ADC_CTRL_PIN 37  //do not change (internally used pin)

const char *displayTexttitle = "Door:"; //shown on the screen
const char *displayTexRX = "(RX)"; //shown on the screen
const char *displayTextDoorOpen = "OPEN"; //shown on the screen
const char *displayTextDoorClosed = "CLOSED"; //shown on the screen
int stayON = 1000;//1 second delay 
const char* displayTexRelayText[] = {displayTextDoorOpen, displayTextDoorClosed};


mbedtls_aes_context aes;
const char *userKey = "6tfDs$wEq3!"; //Security key. 

SSD1306Wire oledDisplay(0x3c, 500000, SDA_OLED, SCL_OLED, GEOMETRY_128_64, RST_OLED);
Robojax_HeltecLoRa32 robojaxDisplay(&oledDisplay);

bool doorState;
String displayTextStateValue; 

#define RF_FREQUENCY                                915000000 // Hz

#define TX_OUTPUT_POWER                             2        // dBm from 2 to 20. when powered via battery 2 to 14dBm

#define LORA_BANDWIDTH                              0         // [0: 125 kHz,
                                                              //  1: 250 kHz,
                                                              //  2: 500 kHz,
                                                              //  3: Reserved]
#define LORA_SPREADING_FACTOR                       12         // [SF7..SF12]
#define LORA_CODINGRATE                             1         // [1: 4/5,
                                                              //  2: 4/6,
                                                              //  3: 4/7,
                                                              //  4: 4/8]
#define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                         0         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_IQ_INVERSION_ON                        false


#define RX_TIMEOUT_VALUE                            1000
#define BUFFER_SIZE                                 30 // Define the payload size here

char txpacket[BUFFER_SIZE];
char rxpacket[BUFFER_SIZE];
bool lora_idle=true;
static RadioEvents_t RadioEvents;

void VextON() {
    pinMode(Vext, OUTPUT);
    digitalWrite(Vext, LOW);
}

void OnTxDone(void);
void OnTxTimeout(void);

void decryptAES(uint8_t *data, const char *key);
void encryptAES(uint8_t *data, const char *key);
void processKey(const char *userKey, uint8_t *processedKey, size_t keySize);



void setup() {
  Serial.begin(115200);
  Serial.println();
  Serial.println();
  pinMode(RELAY_CONTROL_PIN, OUTPUT);//set this pin as output for the relay
  VextON();
  delay(100);
  robojaxDisplay.begin(); 

  //LoRa stuff blow this line
     Mcu.begin(HELTEC_BOARD,SLOW_CLK_TPYE);
    
  
    RadioEvents.RxDone = OnRxDone;
    Radio.Init( &RadioEvents );
    Radio.SetChannel( RF_FREQUENCY );
    Radio.SetRxConfig( MODEM_LORA, LORA_BANDWIDTH, LORA_SPREADING_FACTOR,
                               LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                               LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON,
                               0, true, 0, 0, LORA_IQ_INVERSION_ON, true );
}




void loop() {
  if(debug)
  {
  Serial.print(displayTexttitle);Serial.print(":");
  Serial.println(displayTextStateValue);
  }

 
    robojaxDisplay.displayLineText(displayTexttitle, 0, 0, 24, false);//size 24 font
    robojaxDisplay.displayText(displayTexRX, 127, 5, 10, TEXT_ALIGN_RIGHT);//display TX on the right side

    robojaxDisplay.displayLineText(displayTextStateValue, 0, 30, 24, true);//size 24 font

  if(doorState == true)
  {
    relayON();
  }else{
    relayOFF();
  }

  Radio.IrqProcess( );
  if(lora_idle)
  {
    lora_idle = false;
    Serial.println("into RX mode");
    Radio.Rx(0);
  }

  delay(100);

}

bool isInList(const String& text) {
  for(int i = 0; i < 2; i++) {
    if(text.equals(displayTexRelayText[i])) return true;
  }
  return false;
}

void relayON()
{
  
  digitalWrite(RELAY_CONTROL_PIN, HIGH);
  delay(stayON);
}

void relayOFF()
{
  digitalWrite(RELAY_CONTROL_PIN, LOW);
}
void OnRxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{

    if (size >= BUFFER_SIZE) size = BUFFER_SIZE - 1;
    memcpy(rxpacket, payload, size);
    rxpacket[size] = '\0'; // null-terminate safely

    Radio.Sleep();

    if (debug) {
        Serial.printf("\nReceived packet: \"%s\" | RSSI: %d | Length: %d\n", rxpacket, rssi, size);
    }

    decryptAES((uint8_t *)rxpacket, userKey);

    displayTextStateValue = String((char*)rxpacket);
    doorState = (strcmp(displayTextStateValue.c_str(), displayTextDoorOpen) == 0);

    if(isInList(displayTextStateValue)) {
      Serial.println("Exact match found");
    }else{
      displayTextStateValue ="--";
    }
    if (debug) {
        Serial.print("Decrypted: ");
        Serial.print(displayTextStateValue);
        Serial.print(" doorState:");
        Serial.println(doorState);
    }




    lora_idle = true;
}
/**
 * Converts a user-provided plaintext key into a fixed-length 16-byte (128-bit)
 * or 32-byte (256-bit) key.
 */
void processKey(const char *userKey, uint8_t *processedKey, size_t keySize) {
    memset(processedKey, 0, keySize); // Fill with zeros
    size_t len = strlen(userKey);
    if (len > keySize) len = keySize; // Truncate if too long
    memcpy(processedKey, userKey, len); // Copy valid key part
}

/**
 * Encrypts a 16-byte (one block) message using AES-128.
 */
void encryptAES(uint8_t *data, const char *key) {
    uint8_t processedKey[16]; // 128-bit key
    processKey(key, processedKey, 16);

    mbedtls_aes_init(&aes);
    mbedtls_aes_setkey_enc(&aes, processedKey, 128);
    mbedtls_aes_crypt_ecb(&aes, MBEDTLS_AES_ENCRYPT, data, data);
    mbedtls_aes_free(&aes);
}

/**
 * Decrypts a 16-byte (one block) message using AES-128.
 */
void decryptAES(uint8_t *data, const char *key) {
    uint8_t processedKey[16]; // 128-bit key
    processKey(key, processedKey, 16);

    mbedtls_aes_init(&aes);
    mbedtls_aes_setkey_dec(&aes, processedKey, 128);
    mbedtls_aes_crypt_ecb(&aes, MBEDTLS_AES_DECRYPT, data, data);
    mbedtls_aes_free(&aes);
}