/*
TEXT_ALIGN_LEFT 0
TEXT_ALIGN_CENTER 1
TEXT_ALIGN_RIGHT 2
*/
#include <Wire.h>
#include <HT_SSD1306Wire.h>
#include "LoRaWan_APP.h"
#include <Robojax_HeltecLoRa32.h>

bool debug = false;
#define VOLTAGE_READING_PIN 7  //the pin voltage you are reading from
const int R1 = 39120;//in home. this is 12000 ohm 
const int R2 = 3300;//we read the voltage acrosst this resistor ()
float voltage;

const float CALIB_FACTOR = 1.075f;   // Your calibration factor. 1.0 means do not callibrate
#define BATTERY_PIN 1  //do not change
#define ADC_CTRL_PIN 37  //do not change

SSD1306Wire oledDisplay(0x3c, 500000, SDA_OLED, SCL_OLED, GEOMETRY_128_64, RST_OLED);
Robojax_HeltecLoRa32 robojaxDisplay(&oledDisplay);


#define RF_FREQUENCY                                915000000 // Hz

#define TX_OUTPUT_POWER                             2        // dBm from 2 to 20. when powered via battery 2 to 14dBm

#define LORA_BANDWIDTH                              0         // [0: 125 kHz,
                                                              //  1: 250 kHz,
                                                              //  2: 500 kHz,
                                                              //  3: Reserved]
#define LORA_SPREADING_FACTOR                       7         // [SF7..SF12]
#define LORA_CODINGRATE                             1         // [1: 4/5,
                                                              //  2: 4/6,
                                                              //  3: 4/7,
                                                              //  4: 4/8]
#define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                         0         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_IQ_INVERSION_ON                        false


#define RX_TIMEOUT_VALUE                            1000
#define BUFFER_SIZE                                 30 // Define the payload size here

char txpacket[BUFFER_SIZE];
char rxpacket[BUFFER_SIZE];
bool lora_idle=true;
static RadioEvents_t RadioEvents;

void VextON() {
    pinMode(Vext, OUTPUT);
    digitalWrite(Vext, LOW);
}

void OnTxDone(void);
void OnTxTimeout(void);


void setup() {
    Serial.begin(115200);
    VextON();
    delay(100); // OLED power on delay
    
    pinMode(ADC_CTRL_PIN, OUTPUT);
    // Set ADC_Ctrl to HIGH to enable the ADC circuit.
    digitalWrite(ADC_CTRL_PIN, HIGH);

    robojaxDisplay.begin(); 

    //robojaxDisplay.displayText("Hello", 0, 0, 16, TEXT_ALIGN_LEFT);
    //delay(1000);

  //LoRa stuff
  Mcu.begin(HELTEC_BOARD,SLOW_CLK_TPYE);

    RadioEvents.TxDone = OnTxDone;
    RadioEvents.TxTimeout = OnTxTimeout;
    
    Radio.Init( &RadioEvents );
    Radio.SetChannel( RF_FREQUENCY );
    Radio.SetTxConfig( MODEM_LORA, TX_OUTPUT_POWER, 0, LORA_BANDWIDTH,
                                   LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                                   LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                                   true, 0, 0, LORA_IQ_INVERSION_ON, 3000 ); 
}

void loop() {
  //read the voltage at GPIO7
  voltage = robojaxDisplay.readAnyVoltage(VOLTAGE_READING_PIN, R1, R2);

  if(debug)
  {
   robojaxDisplay.maxVoltage(R1, R2);
  Serial.print("Voltage: ");
  Serial.println(voltage);
  }
   //robojaxDisplay.calculatResistor(R2, 40);
    //robojaxDisplay.displayCenteredText("Robojax!", 24, 24); // Y=24, font size 24
  
    String stringVoltage = String(voltage);  
    robojaxDisplay.displayLineText("Voltage:", 0, 0, 24, false);//size 24 font
    robojaxDisplay.displayLineText(stringVoltage+"V", 0, 30, 24, true);//size 24 font

    robojaxDisplay.sendString( stringVoltage);
  //robojaxDisplay.displaySmallBattery(v);
  delay(500);
  //robojaxDisplay.displayLargeBattery(voltage, 2);
  // delay(2000);
  // robojaxDisplay.displayLargeBattery(v, 2);
  // delay(2000);  

}



void OnTxDone( void )
{
  if(debug)
	Serial.println("TX done......");
	lora_idle = true;
}

void OnTxTimeout( void )
{
    Radio.Sleep( );
    if(debug)
    Serial.println("TX Timeout......");
    lora_idle = true;
}
