
# Robojax_HeltecLoRa32

A flexible Arduino library for the Heltec WiFi LoRa 32 V3 board.  
Created by [Belal @ Robojax](https://github.com/robojax), this library combines OLED display functions with LoRa radio setup, voltage monitoring, and optional AES encryption.

## ✅ Features

- OLED text display (HT_SSD1306Wire)
- LoRa radio initialization via LoRaWan_APP
- Voltage reading and calibration
- AES-128 encryption/decryption
- Helper functions for aligned text and line clearing

---

## 🔧 How to Use

1. Install the Heltec ESP32 board package and this library.
2. Connect the Heltec board via USB.
3. Copy the example code below into an `.ino` file.

---

## 📄 Example Sketch

```cpp
#include <Wire.h>
#include <HT_SSD1306Wire.h>
#include <LoRaWan_APP.h>
#include <Robojax_HeltecLoRa32.h>

SSD1306Wire oledDisplay(0x3c, 500000, SDA_OLED, SCL_OLED, GEOMETRY_128_64, RST_OLED);
Robojax_HeltecLoRa32 robojaxDisplay(&oledDisplay);

RadioEvents_t RadioEvents;

bool lora_idle = true;

void OnTxDone()    { lora_idle = true; Serial.println("TX done"); }
void OnTxTimeout() { lora_idle = true; Serial.println("TX timeout"); }

void VextON() {
    pinMode(Vext, OUTPUT);
    digitalWrite(Vext, LOW);
}

void setup() {
    Serial.begin(115200);
    VextON();
    delay(100);

    RadioEvents.TxDone = OnTxDone;
    RadioEvents.TxTimeout = OnTxTimeout;

    robojaxDisplay.beginWithLoRa(&RadioEvents);  // Initializes OLED + LoRa

    robojaxDisplay.displayText("LoRa Ready", 0, 0, 16, TEXT_ALIGN_LEFT);
    delay(1000);
}

void loop() {
    robojaxDisplay.displayCenteredText("Robojax!", 24, 24);
    delay(2000);
}
```

---

## 📡 LoRa Configuration

Set your radio parameters in the `.ino` file before `setup()`:

```cpp
#define RF_FREQUENCY        915000000
#define TX_OUTPUT_POWER     2
#define LORA_BANDWIDTH      0
#define LORA_SPREADING_FACTOR 7
#define LORA_CODINGRATE     1
#define LORA_PREAMBLE_LENGTH 8
#define LORA_SYMBOL_TIMEOUT  0
#define LORA_FIX_LENGTH_PAYLOAD_ON false
#define LORA_IQ_INVERSION_ON false
```

---

## 🧑‍💻 Author

Belal Shamshiri 

📡 [Robojax YouTube](https://youtube.com/robojax)  
📂 [GitHub: @robojax](https://github.com/robojax)

---

## 📜 License

Private / Restricted — Do not distribute without permission.
