/**
 * File: Robojax_WCS.cpp
Written by Ahmad Shamshiri (Robojax.com) on Mar 15, 2020
Updated to April 04, 2020 (see update log)

 * Description: This is for Allegro ACS linear Hall Effect Sensor.

 * Author: Ahmad Shamshiri
 * Contact: robojax.com
 * Copyright: 2020 Ahmad Shamshiri



    Robojax_WCS.cpp is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
	
Update logs	

2020-July-25 Initial wiring of this libarary	
*/

#include "Arduino.h"
#include "Robojax_WCS.h"

char *Robojax_WCS::_modelNames[][] = {
          //dirct series wiring
		  "WCS38A25",
		  "WCS37A50",
		  "WCS2801",
		  "WCS2702",
		  "WCS2705",
		  "WCS2810",
		  "WCS2720",
		  "WCS2750",
		  "WCS3740",
		  
		  //through hole sensor
		  "WCS1500",
		  "WCS1600",
		  "WCS1700",
		  "WCS1800",
		  "WCS2800",

      };
float Robojax_WCS::_sensitivity[] = {
			7.0,//WCS38A25
			3.5,//WCS37A50
			2.0,//WCS2801
			1.0,//WCS2702
			260.0,//WCS2705
			135.0,//WCS2810
			65.0,//WCS2720
			32.0,//WCS2750
			32.0,//WCS3740
			
			//through hole sensor
			11.0,//WCS1500
			22.0,//WCS1600
			33.0,//WCS1700
			66.0,//WCS1800
			70.0,//WCS2800
		
	};
	
float Robojax_WCS::_quiescent_Output_voltage [] ={
			0.5,//WCS38A25
			0.5,//WCS37A50
			0.5,//WCS2801
			0.5,//WCS2702
			0.5,//WCS2705
			0.5,//WCS2810
			0.5,//WCS2720
			0.5,//WCS2750
			0.5,//WCS3740
			
			//through hole sensor
			0.5,//WCS1500
			0.5,//WCS1600
			0.5,//WCS1700
			0.5,//WCS1800
			0.5,//WCS2800

          };
	  
// -- constructor without VCC
Robojax_WCS::Robojax_WCS(int model, int vinPin)
{
	
    // -- value
   _vin=vinPin;
   _model=model;
   _vcc = 5.0;   

}

// -- constructor without with vcc
Robojax_WCS::Robojax_WCS(int model, int vinPin, float vcc)
{
	
    // -- value
   _vin=vinPin;
   _model=model;
   _vcc =vcc;

}


/*
* getCurrent()
returns the current

 Written by Ahmad Shamshiri on Mar 14, 2020
 www.Robojax.com
 float readCurrent();
*
*/
float Robojax_WCS::getCurrent(){
  readCurrent();
  return this->_current;
}//getCurrent()

/*
 getCurrentAverage
 Get the average of current reading every i count
 i is number of iteration
Written by Ahmad Shamshiri on Mar 15, 2020 at 08:04 in Ajax, Ontario, Canada
*/
float Robojax_WCS::getCurrentAverage(int i){
	float sum =0, average;
	if(i>1)
	{
		for(int c=0; c < i; c++)
		{
			
			sum +=getCurrent();
			
		}
	}else{
		Serial.println("getCurrentAverage(a), a must be greator than 0,\nexample getCurrentAverage(5)");
		exit(1);
	}
	average = sum /i;
	return average;
}//getCurrentAverage end

/*
* readCurrent()
reads the current and sets the _voltage and _current

 Written by Ahmad Shamshiri on Mar 14, 2020
 www.Robojax.com
 float readCurrent();
*
*/
float Robojax_WCS::readCurrent(){
const float FACTOR = this->_sensitivity[this->_model]/1000;// set sensitivity for selected model
const float QOV    = this->_quiescent_Output_voltage [this->_model] * this->_vcc;// set quiescent Output voltage for selected model
float voltage;// internal variable for voltage
  float voltage_raw =   (5.0 / 1023.0)* analogRead(this->_vin);// Read the voltage from sensor
  voltage =  voltage_raw - QOV;
  this->_outVoltage = voltage;
  this->_current = abs(voltage / FACTOR) - (this->_magnetic_offset_error[this->_model]/1000);

  
}//readCurrent()

void Robojax_WCS::debug(){
	Serial.println("Settings");
	Serial.print("\tVersin: ");
	Serial.print(this->_version);
	Serial.print(" Model:");
	Serial.print(this->_model);
	Serial.print(" ");
	Serial.print(_modelNames[this->_model]);	
	Serial.print(" Sensitivity:");
	Serial.print(this->_sensitivity[this->_model]);
	Serial.print(" Quiesent voltage:");
	Serial.println(this->_quiescent_Output_voltage [this->_model]);
	
	Serial.println("Readings");
	Serial.print("\tInput Pin:");
	Serial.print(this->_vin);
	Serial.print("\tSense Voltage:");
	Serial.print(analogRead(this->_vin)* 5.0/1023.0, 3);	
	
	Serial.print("V, Current:");
	Serial.print(this->getCurrent());
	Serial.println("A");
	
	Serial.print("\tAverage of 300 readings: ");
	Serial.print(getCurrentAverage(300));
	Serial.println("A");

	Serial.println("=====================");


}//readCurrent()




